<?php get_header('blog'); ?>
<section class="section ">
	<div class="content">
		<div class="left-side">
			<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
				<article <?php post_class(); ?> id="post-<?php the_ID(); ?>">
					<header>
						<h2 class="entry-title"><?php the_title(); ?></h2>
						<div class="meta">
							<span class="author">By <?php the_author() ?></span>
							<span class="cat">Category: <?php the_category(', ') ?></span>
						</div>
					</header>

					<div class="entry-content">
						<?php the_content(); ?>
					</div>

					<?php wp_link_pages(['before' => '<footer><nav class="page-nav"><p>Pages:', 'after' => '</p></nav></footer>']); ?>

					<!--
					<?php trackback_rdf(); ?>
					-->

					<?php comments_template(); ?>
				</article>

			<?php endwhile; else: ?>

				<?php get_template_part('404'); ?>

			<?php endif; ?>
			<?php if ( is_active_sidebar( 'social_share' ) ) : ?>
			<div class="share">
				<span class="label">Share this article:</span>
				<ul class="social">
					<?php dynamic_sidebar( 'social_share' ); ?>
				</ul>
			</div>
			<?php endif; ?>
		</div>
		<?php get_sidebar(); ?>
	</div>
</section>
<?php get_footer('blog'); ?>