<?php
// Image Sizes
set_post_thumbnail_size( 150, 150, true);
//add_image_size('some', 175, 70);

// Content Width
if (!isset($content_width)) $content_width = 500;

// Menus
register_nav_menus( array(
	'primary' => 'Main Menu',
	'footer' => 'Footer Menu',
	'top' => 'Top Menu'
));

// Widgets
add_action( 'widgets_init', 'mr_widgets_init' );
function mr_widgets_init() {
    register_sidebar(array(
		'id' => 'sidebar',
		'name' => 'Sidebar',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>',
    ));
	
	$args = array(
		'id'            => 'footercol1',
		'name'          => __( 'Footer Column 1', 'text_domain' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4>',
        'after_title' => '</h4>',
	);
	register_sidebar( $args );

	$args = array(
		'id'            => 'footercol2',
		'name'          => __( 'Footer Column 2', 'text_domain' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4>',
        'after_title' => '</h4>',
	);
	register_sidebar( $args );

	$args = array(
		'id'            => 'footercol3',
		'name'          => __( 'Footer Column 3', 'text_domain' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4>',
        'after_title' => '</h4>',
	);
	register_sidebar( $args );

	$args = array(
		'id'            => 'footercol4',
		'name'          => __( 'Footer Column 4', 'text_domain' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4>',
        'after_title' => '</h4>',
	);
	register_sidebar( $args );
	
	$args = array(
		'id'            => 'footercol5',
		'name'          => __( 'Footer Column 5', 'text_domain' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h4>',
        'after_title' => '</h4>',
	);
	register_sidebar( $args );
	
	$args = array(
		'id'            => 'social_share',
		'name'          => __( 'Social Share', 'text_domain' ),
		'description'   => __( 'This will be displayed after the post content and excerpt', 'text_domain' ),
	);
	register_sidebar( $args );
}

// Core Enqueues
function mr_core_scripts_styles() {
	if( is_singular() && comments_open() && get_option('thread_comments') ) {
		wp_enqueue_script('comment-reply');
	}

	wp_enqueue_script( 'jquery-core' );
	wp_enqueue_script( 'jquery.js', get_template_directory_uri().'/assets/js/jquery.js', array( 'jquery-core' ) );
	
	// fancybox
	wp_enqueue_script( 'jquery.mousewheel.js', get_template_directory_uri().'/assets/js/fancybox/jquery.mousewheel-3.0.6.pack.js', array( 'jquery-core' ) );
	wp_enqueue_script( 'jquery.fancybox.js', get_template_directory_uri().'/assets/js/fancybox/jquery.fancybox.js', array( 'jquery-core' ) );
	wp_enqueue_script( 'jquery.fancybox-media.js', get_template_directory_uri().'/assets/js/fancybox/helpers/jquery.fancybox-media.js', array( 'jquery-core' ) );
	
	wp_enqueue_script( 'main.js', get_template_directory_uri().'/assets/js/main.js', array( 'jquery-core' ) );

	wp_enqueue_style( 'fancybox-style', get_template_directory_uri() . '/assets/js/fancybox/jquery.fancybox.css', null, null );
	wp_enqueue_style( 'mr-style', get_stylesheet_uri() );
}
add_action('wp_enqueue_scripts','mr_core_scripts_styles');

// Custom WP Head
function mr_head() {
?>
	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0" />
	<meta name="application-name" content="<?php bloginfo('name'); ?>" />
	<meta name="msapplication-TileColor" content="#ffffff" />
	<!--[if lt IE 9]>
	<script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
	<![endif]-->
	<!--[if IE]>
	<script type="text/javascript" src="<?php echo get_template_directory_uri().'/assets/js/ie.js'; ?>"></script>
	<![endif]-->

<?php
}
add_action('wp_head', 'mr_head');

// Advanced Custom Fields Options Panels
if( function_exists('acf_add_options_page') ) {
	acf_add_options_page();
}

// Remove All Yoast HTML Comments
if ( defined( 'WPSEO_VERSION' ) ){
	add_action( 'get_header', function() {
		ob_start(
			function ($o) {
				return preg_replace( '/\n?<.*?yoast.*?>/mi', '', $o );
			}
		);
	});
	add_action('wp_head', function() {
		ob_end_flush();
	}, 999);
}

// No, bad emojis! (and how much code is required to remove them)
function disable_wp_emojicons() {
	remove_action( 'admin_print_styles', 'print_emoji_styles' );
	remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
	remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
	remove_action( 'wp_print_styles', 'print_emoji_styles' );
	remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
	remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
	remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );
	add_filter( 'tiny_mce_plugins', 'disable_emojicons_tinymce' );
}
add_action( 'init', 'disable_wp_emojicons' );

function disable_emojicons_tinymce( $plugins ) {
	if ( is_array( $plugins ) ) {
		return array_diff( $plugins, array( 'wpemoji' ) );
	} else {
		return array();
	}
}

function new_excerpt_more( $more ) {
	return ' </p><a href="'.get_permalink( get_the_ID() ).'" class="btn">read more</a><p>';
}
add_filter( 'excerpt_more', 'new_excerpt_more' );

function sitemap_pages_shortcode( $atts , $content = null ) {
	// Start buffering
	  ob_start();

	  echo '<ul>';
	  wp_list_pages( array( 'title_li' => '' ) );
	  echo '</ul>';

	  $output = ob_get_contents();
	  
	  // Stop buffering
	  ob_end_clean();
	return $output;
}
add_shortcode( 'sitemap_pages', 'sitemap_pages_shortcode' );

add_filter('wp_footer', function () {
?>
<script>
// page init
jQuery(function(){
	initPopup();
});

/*--- popup ---*/
function initPopup(){
	if(jQuery('#fader').length == 0) jQuery('body').append('<div id="fader"></div>');
	var _fader = jQuery('#fader');
	_fader.hide();
	var _popup = -1;
	
	jQuery('a.popupalt').each(function(){
		var _el = this;
		if(_el.hash && _el.hash.length > 1){
			_el._popup = jQuery(_el.hash);
			if(_el._popup.length){
				_el.onclick = function(){
					if(_el._popup){
						_popup = _el._popup;
						showPopup();
					}
					return false;
				}
				_el._popup.find('a.close').click(function(){
					hidePopup();
					return false;
				});
			}
		}
	});
	_fader.click(function(){
		hidePopup();
		return false;
	});
	
	jQuery(document).keydown(function(e){
		if(!e)evt = window.event;
		if(e.keyCode == 27) hidePopup();
	});
	function showPopup(){
		_fader.css({
			opacity: 0,
			height: initH(),
			display:'block'
		});
		_popup.css({top: jQuery(window).scrollTop()});
		_fader.fadeTo(400, 0.6, function(){
			if(_popup != -1){
				_popup.fadeIn(200);
				var _t = jQuery(window).scrollTop()+ (jQuery(window).height() - _popup.outerHeight())/2;
				if(_t < 0) _t = 0;
				_popup.css({top: _t});
				if(initH() < _popup.outerHeight()+_popup.offset().top) _fader.height(_popup.outerHeight()+_popup.offset().top);
			}
		});
	}
	function hidePopup(){
		if(_popup != -1){
			_popup.fadeOut(400, function(){
				_fader.fadeOut(200);
				_popup = -1;
			});
		}
	}
	function initH(){
		var _h = jQuery('#wrapper').outerHeight();
		if(_h < jQuery(window).height()) _h = jQuery(window).height();
		if(_h < jQuery('body').height()) _h = jQuery('body').height();
		return _h;
	}
}

// custom radio module
jcf.addModule({
	name:'radio',
	selector: 'input[type="radio"]',
	defaultOptions: {
		wrapperClass:'rad-area',
		focusClass:'rad-focus',
		checkedClass:'rad-checked',
		uncheckedClass:'rad-unchecked',
		disabledClass:'rad-disabled',
		radStructure:'<span></span>'
	},
	getRadioGroup: function(item){
		var name = item.getAttribute('name');
		if(name) {
			return jcf.lib.queryBySelector('input[name="'+name+'"]', jcf.lib.getParent('form'));
		} else {
			return [item];
		}
	},
	setupWrapper: function(){
		jcf.lib.addClass(this.fakeElement, this.options.wrapperClass);
		this.fakeElement.innerHTML = this.options.radStructure;
		this.realElement.parentNode.insertBefore(this.fakeElement, this.realElement);
		this.refreshState();
		this.addEvents();
	},
	addEvents: function(){
		jcf.lib.event.add(this.fakeElement, 'click', this.toggleRadio, this);
		if(this.labelFor) {
			jcf.lib.event.add(this.labelFor, 'click', this.toggleRadio, this);
		}
	},
	onFocus: function(e) {
		jcf.modules[this.name].superclass.onFocus.apply(this, arguments);
		setTimeout(jcf.lib.bind(function(){
			this.refreshState();
		},this),10);
	},
	toggleRadio: function(){
		if(!this.realElement.disabled) {
			this.realElement.checked = true;
		}
		this.refreshState();
	},
	refreshState: function(){
		var els = this.getRadioGroup(this.realElement);
		for(var i = 0; i < els.length; i++) {
			var curEl = els[i].jcf;
			if(curEl) {
				if(curEl.realElement.checked) {
					jcf.lib.addClass(curEl.fakeElement, curEl.options.checkedClass);
					jcf.lib.removeClass(curEl.fakeElement, curEl.options.uncheckedClass);
					if(curEl.labelFor) {
						jcf.lib.addClass(curEl.labelFor, curEl.options.labelActiveClass);
					}
				} else {
					jcf.lib.removeClass(curEl.fakeElement, curEl.options.checkedClass);
					jcf.lib.addClass(curEl.fakeElement, curEl.options.uncheckedClass);
					if(curEl.labelFor) {
						jcf.lib.removeClass(curEl.labelFor, curEl.options.labelActiveClass);
					}
				}
				if(curEl.realElement.disabled) {
					jcf.lib.addClass(curEl.fakeElement, curEl.options.disabledClass);
					if(curEl.labelFor) {
						jcf.lib.addClass(curEl.labelFor, curEl.options.labelDisabledClass);
					}
				} else {
					jcf.lib.removeClass(curEl.fakeElement, curEl.options.disabledClass);
					if(curEl.labelFor) {
						jcf.lib.removeClass(curEl.labelFor, curEl.options.labelDisabledClass);
					}
				}
			}
		}
	}
});
    </script>

   <?php
});