<!DOCTYPE html>

<html <?php language_attributes(); ?>>

<head>

	<meta charset="<?php bloginfo( 'charset' ); ?>">	<meta name="robots" content="noodp">
	<link rel="apple-touch-icon" sizes="57x57" href="<?php echo get_template_directory_uri(); ?>/assets/icons/apple-touch-icon-57x57.png">
	<link rel="apple-touch-icon" sizes="60x60" href="<?php echo get_template_directory_uri(); ?>/assets/icons/apple-touch-icon-60x60.png">

	<link rel="apple-touch-icon" sizes="72x72" href="<?php echo get_template_directory_uri(); ?>/assets/icons/apple-touch-icon-72x72.png">

	<link rel="apple-touch-icon" sizes="76x76" href="<?php echo get_template_directory_uri(); ?>/assets/icons/apple-touch-icon-76x76.png">

	<link rel="apple-touch-icon" sizes="114x114" href="<?php echo get_template_directory_uri(); ?>/assets/icons/apple-touch-icon-114x114.png">

	<link rel="apple-touch-icon" sizes="120x120" href="<?php echo get_template_directory_uri(); ?>/assets/icons/apple-touch-icon-120x120.png">

	<link rel="apple-touch-icon" sizes="144x144" href="<?php echo get_template_directory_uri(); ?>/assets/icons/apple-touch-icon-144x144.png">

	<link rel="apple-touch-icon" sizes="152x152" href="<?php echo get_template_directory_uri(); ?>/assets/icons/apple-touch-icon-152x152.png">

	<link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_template_directory_uri(); ?>/assets/icons/apple-touch-icon-180x180.png">

	<link rel="icon" type="image/png" href="<?php echo get_template_directory_uri(); ?>/assets/icons/favicon-32x32.png" sizes="32x32">

	<link rel="icon" type="image/png" href="<?php echo get_template_directory_uri(); ?>/assets/icons/android-chrome-192x192.png" sizes="192x192">

	<link rel="icon" type="image/png" href="<?php echo get_template_directory_uri(); ?>/assets/icons/favicon-96x96.png" sizes="96x96">

	<link rel="icon" type="image/png" href="<?php echo get_template_directory_uri(); ?>/assets/icons/favicon-16x16.png" sizes="16x16">

	<link rel="manifest" href="<?php echo get_template_directory_uri(); ?>/assets/icons/manifest.json">

	<link rel="mask-icon" href="<?php echo get_template_directory_uri(); ?>/assets/icons/safari-pinned-tab.svg" color="#6db939">

	<link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/assets/icons/favicon.ico">

	<meta name="msapplication-TileColor" content="#da532c">

	<meta name="msapplication-TileImage" content="<?php echo get_template_directory_uri(); ?>/assets/icons/mstile-144x144.png">

	<meta name="msapplication-config" content="<?php echo get_template_directory_uri(); ?>/assets/icons/browserconfig.xml">

	<meta name="theme-color" content="#ffffff">

	<?php wp_head(); ?>

 

	<script>
  		(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
  		(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
  		m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
  		})(window,document,'script','https://www.google-analytics.com/analytics.js','ga');

  		ga('create', 'UA-103591654-1', 'auto');
  		ga('send', 'pageview');
	</script>




	<meta name="google-site-verification" content="d8YjNFhUeyu-RMjWdn-zKArw1nAa2L8l382KLZDAs_U" />


<script type="text/javascript">//<![CDATA[
var tlJsHost = ((window.location.protocol == "https:") ? "https://secure.comodo.com/" : "https://www.trustlogo.com/");
document.write(unescape("%3Cscript src='" + tlJsHost + "trustlogo/javascript/trustlogo.js' type='text/javascript'%3E%3C/script%3E"));
//]]>
</script>

</head>

<body <?php body_class(); ?>>

	<div id="wrapper">

		<header id="header">
			<div class="head-sticker">

				<div class="top">

					<div class="content">

						<div class="right">

							<span class="tel">Call Us:

								<a href="<?php the_field('_called_phone_number', 'option'); ?>"><?php the_field('_displayed_phone_number', 'option'); ?></a>

							</span>

							<ul class="sub-menu">

								<?php wp_nav_menu( array( 'theme_location' => 'top' ) ); ?>

							</ul>

						</div>

					</div>

				</div>

				<div class="header-holder">

					<div class="content">

						<strong class="logo"><a href="<?php echo home_url(); ?>">3Gvision</a></strong>

						<a href="#" class="opener">opener</a>

						<nav class="right  hidemenu hideme">

							<?php wp_nav_menu( array( 'theme_location' => 'primary', 'container' => false,

	  'menu_id' => 'nav' ) ); ?>

							<a href="<?php echo site_url(); ?>/get-started/" class="btn">Get Started</a>

						</nav>

					</div>

				</div>
			</div>
			<!-- head sticker -->
				<?php

					if (have_posts()) :

						while (have_posts()) : the_post();

							if( have_rows( '_content' ) ):

								while ( have_rows( '_content' ) ) : the_row();

									$layout = get_row_layout();

									if ($layout=="_call_to_action") include( 'inc/' . $layout . '.php' );

								endwhile;

							endif;

						endwhile;

					endif;

				?>

		</header>



		<div id="main">